/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class StructurePath
implements IStructure {
    private final OpenSimplexNoise heightNoise;
    private final OpenSimplexNoise rigidNoise;
    private final OpenSimplexNoise distortX;
    private final OpenSimplexNoise distortY;

    public StructurePath(long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        this.heightNoise = new OpenSimplexNoise(random.m_188505_());
        this.rigidNoise = new OpenSimplexNoise(random.m_188505_());
        this.distortX = new OpenSimplexNoise(random.m_188505_());
        this.distortY = new OpenSimplexNoise(random.m_188505_());
    }

    @Override
    public void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (int x = 0; x < 16; ++x) {
            int wx = pos.m_123341_() + x;
            context.POS.m_142451_(wx);
            for (int z = 0; z < 16; ++z) {
                int wz = pos.m_123343_() + z;
                context.POS.m_142443_(wz);
                double rigid = this.getRigid(wx, wz) + (double)MHelper.randRange(0.0f, 0.015f, random);
                if (!(rigid < 0.015)) continue;
                int height = this.getHeight(wx, wz);
                context.POS.m_142448_(height);
                height -= BlocksHelper.downRay((LevelAccessor)world, (BlockPos)context.POS, height);
                context.POS.m_142448_(height);
                if (!world.m_46859_((BlockPos)context.POS) || !world.m_8055_((BlockPos)context.POS.m_122173_(Direction.DOWN)).m_60838_((BlockGetter)world, (BlockPos)context.POS) || !this.isHeightValid((LevelAccessor)world, context.POS.m_7494_())) continue;
                Holder biome = world.m_204166_((BlockPos)context.POS);
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)context.POS, this.getRoadMaterial(world, (BlockPos)context.POS, (Holder<Biome>)biome));
                if (this.needsSlab(world, context.POS.m_7494_())) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, context.POS.m_7494_(), this.getSlabMaterial(world, (BlockPos)context.POS, (Holder<Biome>)biome));
                    continue;
                }
                if (!(rigid > 0.01) || (x & 3) != 0 || (z & 3) != 0 || random.m_188503_(8) != 0) continue;
                this.makeLantern((LevelAccessor)world, context.POS.m_7494_());
            }
        }
    }

    private int getHeight(int x, int z) {
        return (int)(this.heightNoise.eval((double)x * 0.001, (double)z * 0.001) * 32.0 + 64.0);
    }

    private double getRigid(double x, double z) {
        return Math.abs(this.rigidNoise.eval((x *= 0.1) * 0.02 + this.distortX.eval(x * 0.05, (z *= 0.1) * 0.05) * 0.2, z * 0.02 + this.distortY.eval(x * 0.05, z * 0.05) * 0.2));
    }

    private boolean isHeightValid(LevelAccessor world, BlockPos pos) {
        return Math.abs(BlocksHelper.downRay(world, pos.m_122013_(2), 5) - BlocksHelper.downRay(world, pos.m_122020_(2), 5)) < 3 && Math.abs(BlocksHelper.downRay(world, pos.m_122030_(2), 5) - BlocksHelper.downRay(world, pos.m_122025_(2), 5)) < 3;
    }

    private void makeLantern(LevelAccessor world, BlockPos pos) {
        BlocksHelper.setWithoutUpdate(world, pos, NetherBlocks.NETHER_BRICK_WALL.m_49966_());
        BlocksHelper.setWithoutUpdate(world, pos.m_7494_(), Blocks.f_50198_.m_49966_());
        BlocksHelper.setWithoutUpdate(world, pos.m_6630_(2), Blocks.f_50198_.m_49966_());
        Direction dir = Direction.NORTH;
        double d = 1000.0;
        double v = this.getRigid(pos.m_123341_(), pos.m_123343_());
        for (Direction face : BlocksHelper.HORIZONTAL) {
            BlockPos p = pos.m_121945_(face);
            double v2 = this.getRigid(p.m_123341_(), p.m_123343_());
            double d2 = v - v2;
            if (!(d2 < d)) continue;
            d = d2;
            dir = face;
        }
        BlockPos p = pos.m_6630_(3);
        BlocksHelper.setWithoutUpdate(world, p, Blocks.f_50198_.m_49966_());
        world.m_46865_(p).m_8113_(new BlockPos(p.m_123341_() & 0xF, p.m_123342_(), p.m_123343_() & 0xF));
        p = p.m_121945_(dir.m_122424_());
        BlocksHelper.setWithoutUpdate(world, p, Blocks.f_50198_.m_49966_());
        world.m_46865_(p).m_8113_(new BlockPos(p.m_123341_() & 0xF, p.m_123342_(), p.m_123343_() & 0xF));
        BlocksHelper.setWithoutUpdate(world, p.m_7495_(), (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)));
    }

    private BlockState getRoadMaterial(ServerLevelAccessor world, BlockPos pos, Holder<Biome> biome) {
        return Blocks.f_50137_.m_49966_();
    }

    private BlockState getSlabMaterial(ServerLevelAccessor world, BlockPos pos, Holder<Biome> biome) {
        return NetherBlocks.BASALT_SLAB.m_49966_();
    }

    private boolean needsSlab(ServerLevelAccessor world, BlockPos pos) {
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            BlockState state = world.m_8055_(pos.m_121945_(dir));
            if (!BlocksHelper.isNetherGround(state) && state.m_60734_() != Blocks.f_50137_ && state.m_60734_() != NetherBlocks.SOUL_SANDSTONE || world.m_8055_(pos.m_7495_().m_121945_(dir.m_122424_())).m_60795_()) continue;
            return true;
        }
        return false;
    }
}

